unit DebugIntoMemo;

{$mode objfpc}{$H+}

{*******************************************************************************
*                                                                              *
*        Debug window functions - print out info text into a TMemo             *
*                                                                              *
*                Created by BREAKOUTBOX in 02-2011                             *
*                Latest changes:  2025-12-05                                   *
*******************************************************************************}

interface

uses
  Interfaces,
  Classes, SysUtils, StdCtrls,
  BasicPortAudioIOobject;


// hide THIS function :
//procedure Memo_ShowCurrentPAHostAPI( var PAObject:TBasicPortAudioIO; var Memo1:TMemo);

procedure Memo_ShowPAVersionInformations( var PAObject:TBasicPortAudioIO;
                                          var Memo1:TMemo;
                                          LibraryName:string);

procedure Memo_ShowIOinformations( var Memo1 : TMemo;
                                   var config : TPortaudioConfig);


implementation

uses
  LConvEncoding,
  LazUTF8,
  portaudio;


procedure Memo_ShowCurrentPAHostAPI( var PAObject:TBasicPortAudioIO; var Memo1:TMemo);
var
  paApiInfo   : PPaHostApiInfo;
  pDeviceInfo : PPaDeviceInfo;
  NumDevices  : Integer;
  s           : String;
begin
  paApiInfo:= Pa_GetHostApiInfo ( PAObject.PA_HostAPI);
  Memo1.Append( 'Selected Portaudio API and Devices :');
  Memo1.Append( '------------------------------------');
  Memo1.Append( '  Host API    :  ' +IntToStr( PAObject.PA_HostAPI) +' = '
                +paApiInfo^.name);

  NumDevices:= paAPIinfo^.deviceCount;
  if NumDevices > 0 then
    begin
      pDeviceInfo := Pa_GetDeviceInfo( PAObject.PA_InputDevice);
      if pDeviceInfo <> NIL then
        begin
          // we need to convert the strings that are not "lazarus / Pascal" strings !
          if IsPureAscii( paApiInfo^.name) // new 2025-12-05
            then s:= pDeviceInfo^.name
            else s:= WinCPToUTF8( pDeviceInfo^.name);
          Memo1.Append( '  Input Dev.  :  ' +IntToStr( PAObject.PA_InputDevice) +' = ' +s);
        end;

      pDeviceInfo := Pa_GetDeviceInfo( PAObject.PA_OutputDevice);
      if pDeviceInfo <> NIL then
        begin
          // we need to convert the strings that are not "lazarus / Pascal" strings !
          if IsPureAscii( paApiInfo^.name) // new 2025-12-05
            then s:= pDeviceInfo^.name
            else s:= WinCPToUTF8( pDeviceInfo^.name);
          Memo1.Append( '  Output Dev. :  ' +IntToStr( PAObject.PA_OutputDevice) +' = ' +s);
        end;
    end;
  Memo1.Append( ''); //empty line
end;


procedure Memo_ShowPAVersionInformations( var PAObject:TBasicPortAudioIO;
                                          var Memo1:TMemo;
                                          LibraryName:string);
begin
  if assigned( Memo1) then   // added 2021-03-13
    with Memo1 do
    begin
      // Memo is cleared EVERY time You change the Host Interface !
      Clear;
      Append( '---- ' +LibraryName +' ----');
      Append( PAObject.Str_PA_VersionNumber);
      Append( PAObject.Str_PA_VersionText);
      Append( ''); //empty line
      Append( PAObject.Str_PA_HostAPICount);
      Append( '----------------------------------');
      Append( PAObject.Str_PA_HostAPI_Strings);
      Append( ''); //empty line
      Memo_ShowCurrentPAHostAPI( PAObject, Memo1);
    end;
end;


procedure Memo_ShowIOinformations( var Memo1 : TMemo;
                                   var config : TPortaudioConfig);
begin
  Memo1.Append( 'Portaudio IO Informations:');
  Memo1.Append( '--------------------------');
  Memo1.Append( '  SampleRate: ' +#9#9 +IntToStr( config.SampleRate) +' Hz');
  Memo1.Append( '  Input channels: ' +#9 +IntToStr( config.TotalNumInputChannels));
  Memo1.Append( '  Output channels:' +#9 +IntToStr( config.TotalNumOutputChannels));
  Memo1.Append( '  FramesPerCallback:' +#9 +IntToStr( config.FramesPerCallback));
  Memo1.Append( ''); //empty line
end;


end.

