unit TypesAndConst;

{$include RELEASE_SETTINGS.INC}

{$mode objfpc}{$H+}

{*******************************************************************************
*
*                  Types and Const for Audio
*
*                  Created by BREAKOUTBOX 2021-02-22
*                  Latest Changes :  2024-07-23
*******************************************************************************}

interface

uses
  LMessages,
  CTypes;


//  This is a general decision for PortAudio AND SimplePlayer
//  You can make it variable, but beware:
//      PortAudio does not accept "any" size of BUFFER_FRAMES value !
//
const
  IO_BUFFER_FRAMES = 512;  { this is not:  Size of Buffer in bytes ! }


const
  LM_END_OF_FILE    = LM_USER +1100;
  LM_PA_STATUSFLAGS = LM_USER +1101;


const
  // for PortaudioAPIselector.pas
  LM_PA_APISELECTOR        = LM_USER +2100;  // Msg
  LM_PA_APISELECTOR_CHANGE = 2;              // Msg.wparam
  LM_PA_STREAM_CLOSED      = 0;              // Msg.lparam
  LM_PA_STREAM_OPENED      = 1;              // Msg.lparam



type
  // if activated, we use float64 instead of float32
  {$ifdef DSP_FLOAT_64}
  DSP_SAMPLE   = cdouble;
  {$ELSE}
  DSP_SAMPLE   = cfloat;
  {$ENDIF}

  DSP_SAMPLE_BUF  = array [0 .. IO_BUFFER_FRAMES -1] of DSP_SAMPLE;
  PDSP_SAMPLE_BUF = ^DSP_SAMPLE_BUF;

  PDSP_SAMPLE_BUF32 = pcfloat;
  PDSP_SAMPLE_BUF64 = pcdouble;

  {$ifdef PORTAUDIO_USE_FLOAT_IO}   // if activated, we use float32 instead of int16 !
  INPUT_SAMPLE   = cfloat;
  OUTPUT_SAMPLE  = cfloat;
  PINPUT_SAMPLE  = ^INPUT_SAMPLE;
  POUTPUT_SAMPLE = ^OUTPUT_SAMPLE;
  PSAMPLE        = pcfloat;  // both I and O
  {$ELSE}             // if not, we use int16 ..
  INPUT_SAMPLE   = cShort;
  OUTPUT_SAMPLE  = cShort;
  PINPUT_SAMPLE  = pcShort;
  POUTPUT_SAMPLE = pcShort;   
  PSAMPLE        = pcShort;  // both I and O
  {$ENDIF}
  INPUTFORMAT    = culong;  //TPaSampleFormat;
  OUTPUTFORMAT   = culong;  //TPaSampleFormat;


// 2021-04-19
// originally was in DSPaudioBufferConversionFunctions.pas :
type
  TInt16BitSample = smallint;
  TFloat32Sample  = single;
  TFloat64Sample  = double;

  P16BitBuffer = ^T16BitBuffer;
  T16BitBuffer = array[0..1023] of TInt16BitSample;

  PFloat32Buffer = ^TFloat32Buffer;
  TFloat32Buffer = array[0..1023] of TFloat32Sample;


implementation


end.

