unit PAerrorObjectCodes;

{$mode objfpc}{$H+}

{*******************************************************************************
*                    PAerrorObjectCodes.pas                                    *
*                                                                              *
*             Error Codes as Strings for PortAudio IO object                   *
*                                                                              *
*                    Created 2024-08-15 by BREAKOUTBOX                         *
*                    Latest changes:  2024-08-15                               *
********************************************************************************
*                                                                              *                                                        *
*******************************************************************************}

interface

uses
  Classes, SysUtils;


{ ---------------------------------------------------------------------------- }
{            Define some application specific error codes here                 }
{                                                                              }
{ Please take into account that Portaudio uses -10000 and higher for errors    }
{ Also check error codes of LibSndFile, LibSamplerate etc ..                   }
{ ---------------------------------------------------------------------------- }
const
  NO_ERROR      =  0;
  DEFAULT_ERROR = -1;
  AFO_Err_Base  = -1100;              // AFO = AudioFileObject
  AFO_Err_01    =  AFO_Err_Base  +1;
  AFO_Err_02    =  AFO_Err_Base  +2;
  SAP_Err_03    =  AFO_Err_Base  +3;
  SAP_Err_04    =  AFO_Err_Base  +4;
  SAP_Err_05    =  AFO_Err_Base  +5;
  // ...
  SAP_Err_99    =  AFO_Err_Base +99;



function GetPAobjectErrorText( err:integer):string;


implementation

function GetPAobjectErrorText( err:integer):string;
begin
  case err of
    AFO_Err_01 : result:= 'SFhandle = Nil';
    AFO_Err_02 : result:= 'blöd gelaufen';
  else
    result:= 'GetPAobjectErrorText for ' +IntToStr( err) +' missing, sorry';
  end;

end;


end.

